﻿using System;
using RimWorld;
using Verse;
using Verse.AI;
using System.Collections.Generic;
using System.Reflection;

namespace SimpleSlavery
{
	public static class SlaveUtility{

		public static bool IsPawnColonySlave(Pawn pawn)
		{
			return pawn.health.hediffSet.HasHediff (HediffDef.Named ("Enslaved"));
		}

		public static bool IsSlaveCollar(Apparel apparel)
		{
			if (apparel.def.defName.Contains ("SlaveCollar"))
				return true;
			return false;
		}

		public static Apparel MakeRandomSlaveCollar()
		{
			var stuff = new List<ThingDef>{
				ThingDef.Named ("Steel"),
				ThingDef.Named ("Silver"),
				ThingDef.Named ("Gold"),
				ThingDef.Named ("Plasteel"),
				ThingDef.Named ("Uranium")
			};
			int chance = (int)Math.Round (Math.Pow(Rand.Value,Math.PI) * (stuff.Count - 1));
			var slaveCollar = ThingMaker.MakeThing (ThingDef.Named ("Apparel_SlaveCollar"), stuff[chance]) as Apparel;
			return slaveCollar;
		}

		public static void GiveSlaveCollar(Pawn pawn, Apparel collar = null)
		{
			if (pawn == null) {
				Log.Error ("Tried to give a collar to a null pawn.");
				return;
			}
			Apparel newCollar = collar;
			if (newCollar == null) 
				newCollar = MakeRandomSlaveCollar ();
			pawn.apparel.Wear (newCollar, false);
			if(pawn.outfits == null)
				pawn.outfits = new Pawn_OutfitTracker ();
			pawn.outfits.forcedHandler.SetForced (newCollar, true);
		}

	}
}

